/**
*    Particle.cpp
*    
*    Class to calculate the motion of a particle moving through space.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "Particle.h"

Particle::Particle(float x, float y, float z, float vX, float vY, float vZ, boolean bounces, float radius, int cubeSize)
{
	_radius = radius;
	_x = x;
	_y = y;
	_z = z;
	_vX = vX;
	_vY = vY;
	_vZ = vZ;
	_bounces = bounces;
	_cubeSize = cubeSize;
}

Particle::Particle()
{
}

void Particle::move(float dt)
{
	float proposedX = _x + _vX*dt;
	if(proposedX > _cubeSize - 1 || proposedX < 0)
	{
		if(_bounces)
		{
			_vX = -_vX;
		}
		else
		{
			_vX = 0;
		}
	}
	float proposedY = _y + _vY*dt;
	if(proposedY > _cubeSize - 1 || proposedY < 0)
	{
		if(_bounces)
		{
			_vY = -_vY;
		}
		else
		{
			_vY = 0;
		}
	}
	float proposedZ = _z + _vZ*dt;
	if(proposedZ > _cubeSize - 1)
	{
	//don't bounce off top
		_vZ = 0;
	}
	if( proposedZ < 0)
	{
		if(_bounces)
		{
			_vZ = -_vZ;
		}
		else
		{
			_vZ = 0;
		}
	}
	_x += _vX*dt;
	_y += _vY*dt;
	_z += _vZ*dt;
}

void Particle::accelerateZ(float aZ, float dt)
{
	_vZ += aZ*dt;
}

void Particle::accelerate(float aX, float aY, float aZ, float dt)
{
	_vX += aX*dt;
	_vY += aY*dt;
	_vZ += aZ*dt;
}

void Particle::drag(float coef, float dt)
{
	float multiple = pow(coef,dt);
	_vX *= multiple;
	_vY *= multiple;
	_vZ *= multiple;
}

boolean Particle::pointIsInSphere(byte x, byte y, byte z)
{
	float xDiff = _x - x;
	if(xDiff > _radius || xDiff < -_radius)
	{
		return false;
	}
	float yDiff = _y - y;
	if(yDiff > _radius || yDiff < -_radius )
	{
		return false;
	}
	float zDiff = _z - z;
	if(zDiff > _radius || zDiff < -_radius )
	{
		return false;
	}
	return (sqrt((x-_x)*(x-_x) + (y-_y)*(y-_y) + (z-_z)*(z-_z)) <= _radius);
}

int Particle::getRoundedX()
{
	return int(_x + .5);
}

int Particle::getRoundedY()
{
	return int(_y + .5);
}

int Particle::getRoundedZ()
{
	return int(_z + .5);
}